import java.util.List;
import java.util.PriorityQueue;
import java.util.Comparator;

// Vergleicht zwei Filme anhand der abgegebenen Stimmen
class MovieComparator implements Comparator<Movie> {
  public int compare(Movie m1, Movie m2) {
    if (m1.votes < m2.votes) {
      return -1;
    } else if (m1.votes > m2.votes) {
      return 1;
    } else {
      return 0;
    }
  }
}

class MovieVoteSearchLoesung {
  PriorityQueue<Movie> movies;

  // Konstruktor
  public MovieVoteSearchLoesung() {
    // Neue PriorityQueue, die Filme anhand der Stimmen sortiert
    movies = new PriorityQueue<Movie>(250, new MovieComparator());
  }

  public void insertMovieWithVotes(int votes, Movie movie) {
    movies.add(movie);
  }

  public Movie getMovieWithFewestVotes() {
    return movies.peek();
  }

  // Dieser Client verwendet Ihre Implementierung
  public static void main(String[] args) {
    MovieVoteSearchLoesung movieSearch = new MovieVoteSearchLoesung();

    // Filme einfuegen
    List<Movie> movies = Movie.readMoviesFromFile("movies.txt");
    for (Movie m : movies) {
      movieSearch.insertMovieWithVotes(m.votes, m);
    }

    // Punktzugriff
    Movie movie = movieSearch.getMovieWithFewestVotes();

    // Ausgabe
    System.out.println(movie);
  }
}